
Description: Multiboot header for GRUB compatibility
Language: assembly
Lines: 156

; SMACKTM Multiboot Header
; Provides GRUB bootloader compatibility

[BITS 32]

; Multiboot constants
MULTIBOOT_MAGIC      equ 0x1BADB002
MULTIBOOT_ALIGN      equ 1 << 0
MULTIBOOT_MEMINFO    equ 1 << 1
MULTIBOOT_FLAGS      equ MULTIBOOT_ALIGN | MULTIBOOT_MEMINFO
MULTIBOOT_CHECKSUM   equ -(MULTIBOOT_MAGIC + MULTIBOOT_FLAGS)

section .multiboot
align 4
    dd MULTIBOOT_MAGIC
    dd MULTIBOOT_FLAGS
    dd MULTIBOOT_CHECKSUM

section .text
global _start
_start:
    ; Multiboot puts us in protected mode already
    ; EBX contains multiboot info structure
    
    ; Save multiboot info
    mov [multiboot_info_ptr], ebx
    
    ; Set up stack
    mov esp, stack_top
    
    ; Call kernel main
    extern kernel_main
    call kernel_main
    
    ; If kernel returns, halt
    cli
    hlt

section .data
multiboot_info_ptr dd 0

section .bss
align 16
stack_bottom:
    resb 16384  ; 16KB stack
stack_top:

================================================================================


### KERNEL MODULE ###

